package gov.va.med.domain.model;
import java.io.Serializable;
import java.util.Date;

/**
 * Super class for all PHR DTOs that are master record.  Used to implement common
 * beahvior and allow polymorphic behavior.  
 * @author Joel Goldberg
 * @version $Id: HealthRecordDomainObject.java,v 1.17 2005/08/19 18:38:26 ed.mather Exp $
 * @since MHV 2.0 <br>March 3, 2005
 */
public  class HealthRecordDomainObject extends DomainObject {
	
    /** nullable persistent field */
    private Patient patient;
    
    /** persistent field */
    private String ien;

    /** The unique identifier of the Patient in MPI */
    private String icn;

    /** The unique local identifier of the Patient at a single Site (VAMC) */
    private String dfn;
        
    private Institution institution;    
        
    public HealthRecordDomainObject() {
        super();   
    }

    public HealthRecordDomainObject(Serializable id, Long versionNumber,
            Date creationDate) {
        super(id, versionNumber, creationDate);
    }    

    public  void setPatient(Patient aPatient){
        patient = aPatient;
    }
    
    /** 
     *            @hibernate.one-to-one
     *             class="gov.va.med.domain.model.HealthRecords"
     *             outer-join="auto"
     *             constrained="true"
     *         
     */
    public Patient getPatient() {
        return patient;
    }
    
    public String getIen() {
        return ien;
    }
    
    public void setIen(String ien) {
        this.ien = ien;
    }
    
    public String getDfn() {
        return dfn;
    }
    
    public void setDfn(String dfn) {
        this.dfn = dfn;
    }
    
    public String getIcn() {
        return icn;
    }
    
    public void setIcn(String icn) {
        this.icn = icn;
    }

    public Institution getInstitution() {
        return institution;
    }    

    public void setInstitution(Institution institution) {
        this.institution = institution;
    }
                
}
